-- Author  : John D P Purba
-- Purpose : Multiplexer 2 ke 1

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY Mux21 IS
	PORT(sel_i   : IN std_logic;
	     din_i 	 : IN bit128;
		 tmp_i 	 : IN tipe_state;
		 tmp_o   : OUT tipe_state
	);
END Mux21;

ARCHITECTURE Mux21_RTL of Mux21 IS

SIGNAL din_map : tipe_state;

BEGIN

	A: FOR baris IN 0 TO 3 GENERATE
   		B: FOR kolom IN 0 TO 3 GENERATE
      		din_map(baris)(kolom) <= din_i(127 - (kolom*32 + baris*8) DOWNTO 
                                           128 - (kolom*32 + (baris + 1)*8));
   		END GENERATE;
	END GENERATE;

	tmp_o <= din_map WHEN sel_i = '0' ELSE tmp_i;
	
END Mux21_RTL;



